-- $Revision: 194 $
-- Cauldron shopping list UI functions

local L = LibStub("AceLocale-3.0"):GetLocale("Cauldron")

function Cauldron:ShoppingList_Toggle()
	
	if CauldronShoppingListFrame then
		if CauldronShoppingListFrame:IsShown() then
			Cauldron:HideShoppingList();
		else
			Cauldron:ShowShoppingList();
		end
	end
	
end

function Cauldron:ShowShoppingList()

	if CauldronShoppingListFrame then
		CauldronShoppingListFrame:Show();

		--[[		
		local s = CauldronShoppingListFrame:GetEffectiveScale();
		
		if self.db.profile.ShoppingListPositionX and self.db.profile.ShoppingListPositionY then
			CauldronShoppingListFrame:SetPoint("TOPLEFT",
											   self.db.profile.ShoppingListPositionX,
											   self.db.profile.ShoppingListPositionY);
		end
		
		if self.db.profile.ShoppingListWidth then
			CauldronShoppingListFrame:SetWidth(self.db.profile.ShoppingListWidth);
		end
		if self.db.profile.ShoppingListHeight then
			CauldronShoppingListFrame:SetHeight(self.db.profile.ShoppingListHeight);
		end
		--]]
		
		self.db.profile.showShoppingList = true;
	end
	
	-- update labels with localized text
	CauldronShoppingListFrameTitleText:SetText(L["Shopping List"]);
	
	Cauldron:UpdateShoppingList();
	
	_G["CauldronShoppingListFrameAutoBuyButton"]:SetChecked(Cauldron:GetAutoBuy());

end

function Cauldron:HideShoppingList()

	if CauldronShoppingListFrame then
		CauldronShoppingListFrame:Hide();
		self.db.profile.showShoppingList = false;
	end

end

function Cauldron:UpdateShoppingList()

	if not CauldronShoppingListFrame:IsShown() then
		return;
	end

	local list = self.db.realm.shopping;
	
	local reqIndex = 1;
	local itemIndex = 1;
	
	local width = CauldronShoppingListFrame:GetWidth();
	local height = CauldronShoppingListFrame:GetHeight();
	
	-- adjust inner frame sizes
	CauldronShoppingListFrameItemsScrollFrame:SetWidth(width - 10);
	CauldronShoppingListFrameItemsScrollFrame:SetHeight(height - 20);
	CauldronShoppingListFrameItemsScrollFrameScrollChild:SetWidth(width - 10);
	
	local frameAbove = nil;
	
	-- iterate over the requestors
	for requestor, items in pairs(list) do
	
		if CauldronShopping:HasItems(list, requestor) then
			
			local shoppingListRequestor = _G["CauldronShoppingListRequestor"..reqIndex];
			
			-- create a frame for the requestor
			if not shoppingListRequestor then
				-- create a new frame for the skill information
				shoppingListRequestor = CreateFrame("Button", 
													"CauldronShoppingListRequestor"..reqIndex, 
													CauldronShoppingListFrameItemsScrollFrameScrollChild,
													"CauldronShoppingListRequestorTemplate");
			end
			
			_G["CauldronShoppingListRequestor"..reqIndex.."Name"]:SetText(requestor);
			_G["CauldronShoppingListRequestor"..reqIndex.."Name"]:SetWidth(width - 10);
			
			_G["CauldronShoppingListRequestor"..reqIndex]:SetWidth(width - 10);
			
			-- place the frame in the scroll view
			if frameAbove then
				-- anchor to the frame above
				self:debug("UpdateShoppingList: anchor frame to top left of frame above");
				shoppingListRequestor:SetPoint("TOPLEFT", frameAbove, "BOTTOMLEFT", 0, -2);
			else
				-- anchor to the parent
				self:debug("UpdateShoppingList: anchor frame to parent");
				shoppingListRequestor:SetPoint("TOPLEFT", CauldronShoppingListFrameItemsScrollFrameScrollChild, "TOPLEFT", 0, 0);
			end
	
			shoppingListRequestor:Show();
			
			frameAbove = shoppingListRequestor;
			
			-- add items for the requestor
			for _,item in ipairs(Cauldron:SortTableIndices(items)) do
--			for item, amount in pairs(items) do
				local amount = items[item];
	
				local shoppingListItem = _G["CauldronShoppingListItem"..itemIndex];
	
				-- create a frame for the item
				if not shoppingListItem then
					-- create a new frame for the skill information
					shoppingListItem = CreateFrame("Button", 
												   "CauldronShoppingListItem"..itemIndex, 
												   CauldronShoppingListFrameItemsScrollFrameScrollChild,
												   "CauldronShoppingListItemTemplate");
				end

--				local _,link,_,_,_,_,_,_,_,_ = GetItemInfo(item);				
				local str = string.format("%s, %d", item, amount);
				
				shoppingListItem.itemName = item;
				shoppingListItem.requestor = requestor;
				
				_G["CauldronShoppingListItem"..itemIndex.."Item"]:SetText(str);
				_G["CauldronShoppingListItem"..itemIndex.."Item"]:SetWidth(width - 25);

				_G["CauldronShoppingListItem"..itemIndex]:SetWidth(width - 25);

				--[[
				local frame = _G["CauldronShoppingListItem"..itemIndex.."ItemTooltipFrame"];
				frame.itemLink = link;				
				--]]
				
				-- place the frame in the scroll view
				if frameAbove then
					-- anchor to the frame above
					self:debug("UpdateShoppingList: anchor frame to top left of frame above");
					shoppingListItem:SetPoint("TOPLEFT", frameAbove, "BOTTOMLEFT", 0, 0);
				end
		
				shoppingListItem:Show();
				
				-- figure out if the current toon has the item, and color it appropriately
				local counts = Cauldron:ReagentCount(item);
				if counts then
					local color = { r=1.0, g=1.0, b=1.0 };
					
					if counts.total > 0 then
						-- the current toon has at least 1 of the item
						color = { r=0.0, g=1.0, b=1.0 };
						
						if counts.has >= amount then
							-- toon has all of them in inventory
							color = { r=0.0, g=1.0, b=0.0 };
						elseif counts.bank > 0 then
							-- toon has some of them in bank
							color = { r=1.0, g=0.0, b=1.0 };
						elseif counts.mail > 0 then
							-- toon has some in the mail
							color = { r=1.0, g=1.0, b=0.0 };
						end
					end
					
					_G["CauldronShoppingListItem"..itemIndex.."Item"]:SetTextColor(color.r, color.g, color.b, 1.0);
				end
				
				frameAbove = shoppingListItem;
				
				itemIndex = itemIndex + 1;
				
			end
	
			reqIndex = reqIndex + 1;
	
		end
	end
	
	-- set scroll child frame height
	CauldronShoppingListFrameItemsScrollFrameScrollChild:SetHeight((reqIndex - 1) * 12 + (itemIndex - 1) * 12);
	
	while true do
		local frame = _G["CauldronShoppingListRequestor"..reqIndex];
		if not frame then
			break;
		end
		
		frame:Hide();
--		frame:SetHeight(0);
		
		reqIndex = reqIndex + 1;
	end	
	while true do
		local frame = _G["CauldronShoppingListItem"..itemIndex];
		if not frame then
			break;
		end
		
		frame:Hide();
--		frame:SetHeight(0);
		
		itemIndex = itemIndex + 1;
	end	
	
end

function Cauldron:AutoBuyShoppingList_OnClick(button)
	local checked = button:GetChecked() or 0;
--	checked = (checked > 0) ? true : false;
	Cauldron.db.realm.userdata[Cauldron.vars.playername].options.autoBuy = checked;
end

