
CPFrame = nil;
--local numCP = 0;

local CPLayouts = {
	[0] = {
		[1] = {["x"] = -58, ["y"] = -148+32 },
		[2] = {["x"] = -30, ["y"] = -160+32 },
		[3] = {["x"] =   0, ["y"] = -166+32 },
		[4] = {["x"] =  30, ["y"] = -160+32 },
		[5] = {["x"] =  58, ["y"] = -148+32 }
	},
	[1] = {
		[1] = {["x"] = -58, ["y"] = 148-150 },
		[2] = {["x"] = -30, ["y"] = 160-150 },
		[3] = {["x"] =   0, ["y"] = 166-150 },
		[4] = {["x"] =  30, ["y"] = 160-150 },
		[5] = {["x"] =  58, ["y"] = 148-150 }
	}
};

function CPSetLayout(n)
	for i=1,5 do
		CPFrame.cppoints[i]:SetPoint("CENTER", "ccMod_ComboPointsFrame", "CENTER", CPLayouts[n][i]["x"], CPLayouts[n][i]["y"]);
	end
end

function CPFrame_OnLoad()
	CPFrame = getglobal("ccMod_ComboPointsFrame");
	CPFrame.numCP = 0;
	CPFrame.lastCP = 0;
	this.cppoints = {};
	for i=1,5 do
		this.cppoints[i] = getglobal("ccMod_ComboPoint"..i);
		this.cppoints[i]:Hide();
	end
	this:RegisterEvent("PLAYER_COMBO_POINTS");
	this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("UNIT_AURA");
end


function CPFrame_OnEvent(event)
	if (event == "UNIT_AURA" and arg1 ~= "target") then
		return;
	end
	local cp = GetComboPoints();
	local dp = GetDeadlyPoisonPoints();
	if (cp == 0) then
		if (CPFrame.numCP > 0) then
			CPFrame.numCP = 0;
			HideCPPoints();
		else
			CPFrame.numCP = 0;
			HideCPPoints();
		end
	elseif (cp > 0) then
		for i=1,5 do
			if (cp >= i) then
				CPFrame.numCP = i;
				CPFrame.lastCP = i;
				this.cppoints.startTime = GetTime();
				this.cppoints[i]:Show();
				if (dp >= i) then
					this.cppoints[i].dptext:Show();
				else
					this.cppoints[i].dptext:Hide();
				end
			else
				this.cppoints[i].dptext:Hide();
				this.cppoints[i]:Hide();
			end
		end
	end
end

function HideCPPoints()
	CPFrame.numCP = 0;
	for i=1,5 do
		CPFrame.cppoints[i]:Hide();
	end
end
function ShowCPPoints()
	CPFrame.numCP = 0;
	for i=1,5 do
		CPFrame.cppoints[i]:Show();
	end
end




function GetDeadlyPoisonPoints()
	for i=1, 16, 1 do
		local debuffName, debuffRank, debuffTexture, debuffApplications, debuffType = UnitDebuff("target", i);
		if (debuffName == "Deadly Poison VII") then
			return debuffApplications;
		end
	end
	return 0;
end
