------------------------------------------------------------------------------------------------------
-- Sabella
--
-- Maintainer : Isognomy
--
-- Based on Ideas by:
--   Serenity and Cryolysis by Kaeldra of Aegwynn 
--   Necrosis LdC by Lomig and Nyx (http://necrosis.larmes-cenarius.net)
--   Original Necrosis Idea : Infernal (http://www.revolvus.com/games/interface/necrosis/)
------------------------------------------------------------------------------------------------------

-- localisation
local L = AceLibrary('AceLocale-2.2'):new('Sabella');
-- timer functions
local metro = AceLibrary("Metrognome-2.0");
local bs = AceLibrary('Babble-Spell-2.2');
-- configuration
function SabellaConfig_Toggle()
    if InCombatLockdown() then
		DEFAULT_CHAT_FRAME:AddMessage(L['MSG_INCOMBAT']);
        return;
    end
    -- load configuration dialog
	local loaded, message = LoadAddOn('SabellaOptions');
	if (loaded) then
		PlaySound('igMainMenuOpen');
		if (not SabellaOptions.initialized) then
			SabellaOptions:Initialize();
			SabellaOptions.initialized = true;
			ShowUIPanel(SabellaOptionsFrame);
		elseif (SabellaOptionsFrame:IsVisible()) then
			HideUIPanel(SabellaOptionsFrame);
		else
            SabellaOptions:UpdateData();
			ShowUIPanel(SabellaOptionsFrame);
		end
	else
		PlaySound('TellMessage');
        if message ~= nil then
            DEFAULT_CHAT_FRAME:AddMessage(L['LOAD_ERROR']..': '..message);
        else
            DEFAULT_CHAT_FRAME:AddMessage(L['LOAD_ERROR']);        
        end
	end
end
-- If the Debug library is available then use it

if AceLibrary:HasInstance('AceDebug-2.0') then
	Sabella = AceLibrary('AceAddon-2.0'):new(
        'AceConsole-2.0', 'AceEvent-2.0', 'AceDB-2.0', 'AceDebug-2.0', 
        'SphereCore-2.0', 'SphereButtons-2.0', 'SphereInventory-2.0'
    );
else
	Sabella = AceLibrary('AceAddon-2.0'):new(
        'AceConsole-2.0', 'AceEvent-2.0', 'AceDB-2.0', 
        'SphereCore-2.0', 'SphereButtons-2.0', 'SphereInventory-2.0'
    );
end

SABELLA_SPELLS = {        
    ['EVISCERATE'] = 'Eviscerate',
    ['SINISTER_STRIKE'] = 'Sinister Strike',
    ['STEALTH'] = 'Stealth',
    ['BACKSTAB'] = 'Backstab',
    ['PICK_POCKET'] = 'Pick Pocket',
    ['GOUGE'] = 'Gouge',
    ['EVASION'] = 'Evasion',
    ['SAP'] = 'Sap',
    ['SLICE_AND_DICE'] = 'Slice and Dice',
    ['SPRINT'] = 'Sprint',
    ['KICK'] = 'Kick',
    ['EXPOSE_ARMOR'] = 'Expose Armor',
    ['GARROTE'] = 'Garrote',
    ['FEINT'] = 'Feint',
    ['PICK_LOCK'] = 'Pick Lock',
    ['AMBUSH'] = 'Ambush',
    ['ADRENALINE_RUSH'] = 'Adrenaline Rush',
    ['BLADE_FLURRY'] = 'Blade Flurry',
    ['RUPTURE'] = 'Rupture',
    ['PREMEDITATION'] = 'Premeditation',
    ['DISTRACT'] = 'Distract',
    ['VANISH'] = 'Vanish',
    ['CHEAP_SHOT'] = 'Cheap Shot',
    ['DISARM_TRAP'] = 'Disarm Trap',
    ['KIDNEY_SHOT'] = 'Kidney Shot',
    ['BLIND'] = 'Blind',
    ['MUTILATE'] = 'Mutilate',
    ['ENVENOM'] = 'Envenom',
    ['DEADLY_THROW'] = 'Deadly Throw',
    ['CLOAK_OF_SHADOWS'] = 'Cloak of Shadows',
    ['HEMORRHAGE'] = 'Hemorrhage',
    ['SHIV'] = 'Shiv',
    ['PREPARATION'] = 'Preparation',
    ['WILL_OF_THE_FORSAKEN'] = 'Will of the Forsaken',
    ['CANNIBALIZE'] = 'Cannibalize',
    ['MANA_TAP'] = 'Mana Tap',
    ['ARCANE_TORRENT'] = 'Arcane Torrent',
    ['ESCAPE_ARTIST'] = 'Escape Artist',
    ['STONEFORM'] = 'Stoneform',
    ['SHADOWMELD'] = 'Shadowmeld',
    ['BERSERKING'] = 'Berserking',
    ['PERCEPTION'] = 'Perception',
    ['BLOOD_FURY'] = 'Blood Fury'
}
-- startup/close functions

function Sabella:OnInitialize()
    self:SphereRegisterSkins({'The Blues', 'Red Hot', 'Classic'});
    
    self.options = { 
        type = 'group',
        args = {
            menu = {
                type = 'execute',
                name = 'Menu',
                desc = L['TOGGLE_CONFIG'],
                func = SabellaConfig_Toggle,
            },
            minimap = {
                type = 'execute',
                name = 'Minimap',
                desc = L['TOGGLE_MINIMAP'],
                func = Sabella_MinimapToggle,               
            }
        }
    }
    self:RegisterChatCommand(L['SLASH_COMMANDS'], self.options);

    self.dbDefaults = {
        sphereLocking = false, 
        sphereSkin = 1; -- 1 = Solid, 2 = Flat
        sphereRotation = 0, -- button rotation in degrees
        sphereOpacity = 90, -- sphere alpha opacity in percent
        sphereScale = 100, -- scale in percent
        sphereStatusCircle = 0, -- show on sphere circle
        sphereStatusText = 0, -- show on sphere text
        sphereActionLeft = 0, -- left click one sphere
        sphereActionRight = 0, -- right click on sphere
        -- menu behaviour 
        menuKeepOpen = false;
        menuCloseTimeout = 2;
        -- remember spells
        rememberStealthMenu = {
            [0] = '',
            [1] = '',
        },
        rememberReagentsMenu = {
            [0] = '',
            [1] = '',
        },
        -- button
        buttonOrderCCW = false, -- button order direction (false = clockwise, true = counter clockwise)
        buttonOpacity = 100, -- sphere alpha opacity in percent
        buttonScale = 100, -- scale buttons
        buttonLocking = true, -- lock buttons to sphere
        buttonTooltips = true, -- tooltips on buttons and sphere?
        buttonDefaultTooltips = false; -- use default tooltip position
        buttonsUseGrid = true; --use a grid of 10px to align buttons
        -- buttons visible or not
        buttonDrinkVisible = true,
        buttonPotionVisible = true,
        buttonMountVisible = true,
        buttonStealthMenuVisible = true,
        buttonThistleVisible = true,
        buttonBandageVisible = true,
        buttonActionOneVisible = true,
        buttonActionTwoVisible = true,
        buttonActionThreeVisible = true,
        buttonActionPoisonsVisible = true,
	-- action button clicks
        buttonActionOneLeft = 0,
        buttonActionOneRight = 0,
        buttonActionTwoLeft = 0,
        buttonActionTwoRight = 0,
        buttonActionThreeLeft = 0,
        buttonActionThreeRight = 0,
        buttonActionPoisonsLeft = 0,
        buttonActionPoisonsRight = 0,
        -- potion and drink/food button options
        buttonPotionWeakest = false,
        buttonDrinkWeakest = false,
	buttonPoisonWeakest = false,
        -- messages
        messagesLanguage = 0,
        messagesOnScreen = true,
        messagesMissingTexture = false;
        messagesRandom = false,
        messagesRandomEvasionSpeech = true,
        messagesRandomEvis = true,
        messagesRandomSprint = true,
        messagesRandomBackStab = true,
        messagesRandomSap = true,
        messagesRandomMount = true,
	--Timers
	enabletimers = true,
    };

    self:RegisterDB('SabellaDB', 'SabellaDBPC');
    self:RegisterDefaults('profile', self.dbDefaults);

    self:InitPlayerInfos();
    -- Called when the addon is loaded
    self:ButtonSetup('Sabella', {'Potion', 'Drink', 'Thistle', 'Bandage', 'Mount', 'StealthMenu', 'ActionPoisons', 'ActionOne', 'ActionTwo', 'ActionThree'});
    self:RegisterSpells(SABELLA_SPELLS);
    self:ButtonRegisterActions({    
        { type = 'slot', data = 'Trinket0Slot' }, --First trinket slot
        { type = 'slot', data = 'Trinket1Slot' }, --Second trinket slot     
        { type = 'spell', data = 'EVISCERATE' },
	{ type = 'spell', data = 'SINISTER_STRIKE' },
	{ type = 'spell', data = 'STEALTH' },
        { type = 'spell', data = 'BACKSTAB' },
        { type = 'spell', data = 'PICK_POCKET' },
        { type = 'spell', data = 'GOUGE' },
	{ type = 'spell', data = 'EVASION' },
	{ type = 'spell', data = 'SAP' },
        { type = 'spell', data = 'SLICE_AND_DICE' },
	{ type = 'spell', data = 'SPRINT' },
	{ type = 'spell', data = 'KICK' },
        { type = 'spell', data = 'EXPOSE_ARMOR' },
        { type = 'spell', data = 'GARROTE' },
	{ type = 'spell', data = 'FEINT' },
	{ type = 'spell', data = 'PICK_LOCK' },
        { type = 'spell', data = 'AMBUSH' },
        { type = 'spell', data = 'ADRENALINE_RUSH' },
	{ type = 'spell', data = 'BLADE_FLURRY' },
        { type = 'spell', data = 'RUPTURE' },
	{ type = 'spell', data = 'PREMEDITATION' },	
	{ type = 'spell', data = 'DISTRACT' },
	{ type = 'spell', data = 'VANISH' },
        { type = 'spell', data = 'CHEAP_SHOT' },
	{ type = 'spell', data = 'DISARM_TRAP' },
	{ type = 'spell', data = 'KIDNEY_SHOT' },
        { type = 'spell', data = 'BLIND' },
	{ type = 'spell', data = 'MUTILATE' },
        { type = 'spell', data = 'ENVENOM' },
	{ type = 'spell', data = 'DEADLY_THROW' },
	{ type = 'spell', data = 'CLOAK_OF_SHADOWS' },
	{ type = 'spell', data = 'HEMORRHAGE' },
        { type = 'spell', data = 'SHIV' },
        { type = 'spell', data = 'PREPARATION' },
        { type = 'spell', data = 'WILL_OF_THE_FORSAKEN' },
        { type = 'spell', data = 'CANNIBALIZE' },
        { type = 'spell', data = 'MANA_TAP' },
        { type = 'spell', data = 'ARCANE_TORRENT' },
	{ type = 'spell', data = 'ESCAPE_ARTIST' },
	{ type = 'spell', data = 'STONEFORM' },
	{ type = 'spell', data = 'SHADOWMELD' },
	{ type = 'spell', data = 'BERSERKING' },
	{ type = 'spell', data = 'PERCEPTION' },
	{ type = 'spell', data = 'BLOOD_FURY' },
        { type = 'item', data = 'Deadly Poison' }, 
        { type = 'item', data = 'Deadly Poison II' },  
        { type = 'item', data = 'Deadly Poison III' },  
        { type = 'item', data = 'Deadly Poison IV' },  
        { type = 'item', data = 'Deadly Poison V' },
        { type = 'item', data = 'Deadly Poison VI' },
	{ type = 'item', data = 'Deadly Poison VII' },
        { type = 'item', data = 'Improved Deadly Poison' },
        { type = 'item', data = 'Crippling Poison' }, 
        { type = 'item', data = 'Crippling Poison II' },
        { type = 'item', data = 'Instant Poison'},
	{ type = 'item', data = 'Instant Poison II' }, 
	{ type = 'item', data = 'Instant Poison III' },
	{ type = 'item', data = 'Instant Poison IV' },
	{ type = 'item', data = 'Instant Poison V' },
	{ type = 'item', data = 'Instant Poison VI' },
	{ type = 'item', data = 'Instant Poison VII' },
	{ type = 'item', data = 'Improved Instant Poison' }, 
        { type = 'item', data = 'Wound Poison II' },
        { type = 'item', data = 'Wound Poison III' },  
        { type = 'item', data = 'Wound Poison IV' },  
        { type = 'item', data = 'Wound Poison V' },
        { type = 'item', data = 'Wound Poison' },  
        { type = 'item', data = 'Mind-numbing Poison' },
        { type = 'item', data = 'Mind-numbing Poison II' },    
	{ type = 'item', data = 'Mind-numbing Poison III' },    
        { type = 'item', data = 'Anesthetic Poison' },    
    });
    self:ButtonRegisterMenu('StealthMenu', {   
        { type = 'spell', data = 'STEALTH' }, 
        { type = 'spell', data = 'PICK_POCKET' },  
        { type = 'spell', data = 'BACKSTAB' },  
        { type = 'spell', data = 'SAP' },  
        { type = 'spell', data = 'GARROTE' },
        { type = 'spell', data = 'AMBUSH' },
	{ type = 'spell', data = 'CHEAP_SHOT' },
    });
    self:SphereRegisterStatus(
        {'MANA', 'HEALTH', 'XP'},
        {'MANA', 'HEALTH', 'CP'}
    );
    self:RegisterSpeechLanguage('enUS', SABELLA_RANDOM_MESSAGES_enUS);

    
    metro:Register("SabellaTimer", self.OnTimerTick, 1, self);
end

function Sabella:OnEnable()
    -- starting up
    self:RegisterEvent('PLAYER_ENTERING_WORLD');
    -- new zone
    self:RegisterEvent('ZONE_CHANGED_NEW_AREA');
        
    -- monitor some status infos
    self:RegisterEvent('UNIT_HEALTH');
    self:RegisterEvent('UNIT_MANA');
    
    -- some basic info has changed
    self:RegisterEvent('SPELLS_CHANGED');
    self:RegisterEvent('BAG_UPDATE');
    
    -- capture spellcasts (messages, recasts)
    self:RegisterEvent('UNIT_SPELLCAST_SENT');
    self:RegisterEvent('UNIT_SPELLCAST_FAILED'); 
    self:RegisterEvent('UNIT_SPELLCAST_INTERRUPTED'); 
    self:RegisterEvent('UNIT_SPELLCAST_STOP');
    self:RegisterEvent('UNIT_SPELLCAST_SUCCEEDED');     
    
    -- leaving combat - do pending updates
    self:RegisterEvent('PLAYER_LEAVE_COMBAT');
    
    -- start the update timer
    metro:Start("SabellaTimer");
    SabellaMaxHealth = UnitHealthMax('player');
    SabellaLowHealth = SabellaMaxHealth / 3;
end

-- timer ticks
function Sabella:OnTimerTick()
    self:UpdateStatus();
end

-- event callbacks
function Sabella:PLAYER_ENTERING_WORLD()
    self:InitPlayerInfos();
    self:MountZoneInformation();
    self:UpdateSpellTable();
    self:InventoryScan();
    self:UpdateActions();
    self:UpdateStatus();
end

function Sabella:SPELLS_CHANGED()
    self:UpdateSpellTable();
    self:UpdateActions();
    self:UpdateStatus();
end

function Sabella:BAG_UPDATE()
    self:InventoryScan();
    self:UpdateActions();
    self:UpdateStatus();
    self:UpdateStatus();
end

function Sabella:ZONE_CHANGED_NEW_AREA()
    self:MountZoneInformation();
    self:UpdateActions();
end

function Sabella:UNIT_SPELLCAST_SENT(unitId, spell, rank, target)
    if unitId == 'player' then
        self:OnSpellCastStart(spell, rank, target);
        self.lastSpell = {
            ['spell'] = spell,
            ['rank'] = rank,
            ['target'] = target
        }
    end
end

function Sabella:UNIT_SPELLCAST_STOP(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
        if self.lastSpell ~= nil then
            self:OnSpellCast(self.lastSpell.spell, self.lastSpell.rank, self.lastSpell.target);
            self.lastSpell = nil;
        end
    end
end

function Sabella:UNIT_SPELLCAST_FAILED(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
        if self.lastSpell ~= nil then
            self.lastSpell = nil;
        end
    end
end

function Sabella:UNIT_SPELLCAST_INTERRUPTED(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
    end
end

function Sabella:UNIT_SPELLCAST_SUCCEEDED(unitId, spell, rank)
    if unitId == 'player' then
        if self.lastSpell ~= nil then
            if self.lastSpell ~= nil and spell == self.lastSpell.spell then
                self:OnSpellCast(spell, rank, self.lastSpell.target);
            end
            self.lastSpell = nil;
        end
    end
end

-- status update events
function Sabella:UNIT_HEALTH()
    self:UpdateStatus();
   if (VanishWarning == 0) then
    if (UnitHealth('player') < SabellaLowHealth) then
	UIErrorsFrame:AddMessage("You are going to die, vanish now!!", 1.0, 0.0, 0.0, 1.0, 30);
	VanishWarning = 1;
    end
   else
    if (UnitHealth('player') > SabellaLowHealth) then
        VanishWarning = 0;
    end
   end
end
function Sabella:UNIT_MANA()
    self:UpdateStatus();
end

-- pending updates
function Sabella:PLAYER_LEAVE_COMBAT()
    if self.updatePending then
        self:UpdateActions();    
    end
    self:UpdateStatus();
end

-- tooltip functions
function Sabella:ShowTooltip(element, buttonId, anchor)
    if not self.db.profile.buttonTooltips then
        return
    end
  
    if self.db.profile.buttonDefaultTooltips then
        GameTooltip_SetDefaultAnchor(GameTooltip, element);    
    else
        GameTooltip:SetOwner(element, anchor);
    end
  
    if buttonId == 'MAIN' then    
	GameTooltip:AddLine('Sabella 3.30');
	GameTooltip:AddLine('----------------------------------------------------------');
	local itemCount, itemName = self:InventoryGetItemData('REAGENT');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	GameTooltip:AddLine('----------------------------------------------------------');
	local itemCount, itemName = self:InventoryGetItemData('THISTLETEA');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	GameTooltip:AddLine('----------------------------------------------------------');
        local itemCount, itemName = self:InventoryGetItemData('FOOD');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('FOODBONUS');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	GameTooltip:AddLine('----------------------------------------------------------');
	local itemCount, itemName = self:InventoryGetItemData('BANDAGE');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end       
	local itemCount, itemName = self:InventoryGetItemData('BGBANDAGE');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end       
        local itemCount, itemName = self:InventoryGetItemData('POTION_HP');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end 
        local itemCount, itemName = self:InventoryGetItemData('HEALTHSTONE');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end        
	GameTooltip:AddLine('----------------------------------------------------------');
	local itemCount, itemName = self:InventoryGetItemData('DEADLY_POISON');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	local itemCount, itemName = self:InventoryGetItemData('INSTANT_POISON');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	local itemCount, itemName = self:InventoryGetItemData('NUMB_POISON');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	local itemCount, itemName = self:InventoryGetItemData('CRIPPLE_POISON');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	local itemCount, itemName = self:InventoryGetItemData('WOUND_POISON');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
	GameTooltip:AddLine('----------------------------------------------------------');
	for i=1, GetNumSkillLines() do
	  local skillName, header, _, skillRank, _, _, skillMaxRank= GetSkillLineInfo(i)
	if skillName and not header then
	   if skillName == "Lockpicking" then
           GameTooltip:AddDoubleLine(skillName.. ': ', skillRank.. '/ '.. skillMaxRank, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
	else
	   skillName = nil
	   end
	end
        end
	GameTooltip:AddLine('----------------------------------------------------------');
        local _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.profile.sphereActionLeft);
        local _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.profile.sphereActionRight);  
        if actionLeftName then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            if actionLeftTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionLeftName, actionLeftTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionLeftName, 0.8, 0.8, 0.1);
            end
            if actionLeftCooldown and actionLeftCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionLeftCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
        if actionRightName then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            if actionRightTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionRightName, actionRightTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionRightName, 0.8, 0.8, 0.1);
            end
            if actionRightCooldown and actionRightCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionRightCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
    elseif buttonId == 'DRINK' then
		GameTooltip:AddLine(L['TOOLTIP_DRINKFOOD']);
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'FOOD');
        self:TooltipAddItemData(GameTooltip, 'LeftButton', 'FOODBONUS');
    elseif buttonId == 'POTION' then
		GameTooltip:AddLine(L['TOOLTIP_POTION']);
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'POTION_HP');
        self:TooltipAddItemData(GameTooltip, 'LeftButton', 'HEALTHSTONE');
    elseif buttonId == 'BANDAGE' then
		GameTooltip:AddLine(L['TOOLTIP_BANDAGE']);
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'BANDAGE');
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'BGBANDAGE');
    elseif buttonId == 'THISTLE' then
		GameTooltip:AddLine(L['TOOLTIP_THISTLE']);
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'THISTLETEA');
    elseif buttonId == 'MOUNT' then    
        if UnitOnTaxi('player') then
            GameTooltip:AddLine(L['UNIT_ON_TAXI'], 1.0, 1.0, 1.0);
        end
        local _, _, itemName = self:InventoryGetMountData();
        if itemName ~= nil then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            GameTooltip:AddLine(itemName, 0.8, 0.8, 0.1);
        end
        local _, itemName, _, _, cooldown = self:InventoryGetItemData('HEARTHSTONE');
        if itemName ~= nil then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            GameTooltip:AddLine(itemName..' ('..GetBindLocation()..')', 0.8, 0.8, 0.1);
            if cooldown and cooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
        elseif buttonId == 'ACTION_ONE' or buttonId == 'ACTION_TWO' or buttonId == 'ACTION_THREE' or buttonId == 'ACTION_POISONS' then
        local actionLeftName, actionLeftTooltip, actionLeftCooldown;
        local actionRightName, actionRightTooltip, actionRightCooldown;
        if buttonId == 'ACTION_ONE' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionOneLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionOneRight);
        elseif buttonId == 'ACTION_TWO' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionTwoLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionTwoRight);
        elseif buttonId == 'ACTION_THREE' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionThreeLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionThreeRight);
        elseif buttonId == 'ACTION_POISONS' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionPoisonsLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.profile.buttonActionPoisonsRight);
        end
        if actionLeftName then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            if actionLeftTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionLeftName, actionLeftTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionLeftName, 0.8, 0.8, 0.1);
            end
            if actionLeftCooldown and actionLeftCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionLeftCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
        if actionRightName then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            if actionRightTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionRightName, actionRightTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionRightName, 0.8, 0.8, 0.1);
            end
            if actionRightCooldown and actionRightCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionRightCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
    elseif  buttonId == 'STEALTHMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'StealthMenu');
    elseif buttonId == 'ATTRIBUTES' then
        local buttonType = element:GetAttribute('type1');
        if buttonType ~= nil then
            local buttonAction = element:GetAttribute(buttonType..'1');
            if buttonType == 'spell' then
                -- spell name to Sabella spell id
                if self.spellTableRevIndex ~= nil and self.spellTableRevIndex[buttonAction] ~= nil then
                    -- Sabella spell id to spell data
                    local spellData = self.spellTable[self.spellTableRevIndex[buttonAction]];
                    -- check data and set tooltip
                    if spellData ~= nil and spellData.index ~= nil and spellData.index > 0 then
                        GameTooltip:SetSpell(spellData.index, BOOKTYPE_SPELL);
                    end
                end
            end
        end
    elseif  buttonId == 'BANDAGE' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'Bandage');
    elseif  buttonId == 'THISTLE' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'Thistle');
    end
  
	-- and done, show it!
	GameTooltip:Show();
end

function Sabella:TooltipAddItemData(tooltip, button, itemGroup)
    local itemCount, itemName, _, _, cooldown = self:InventoryGetItemData(itemGroup);
    if itemName ~= nil then
        if button == 'LeftButton' then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
        elseif button == 'RightButton' then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
        end
        GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        if cooldown and cooldown > 0 then
            local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldown);
            GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
        end
    end
end

function Sabella:TooltipAddMenuSpellData(tooltip, menuId)
    local optionName = 'remember'..menuId;
    if self.db.profile[optionName] ~= nil then
        local _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:GetActionInfo('spell', self.db.profile[optionName][1]);
        if actionRightName then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            if actionRightTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionRightName, actionRightTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionRightName, 0.8, 0.8, 0.1);
            end
            if actionRightCooldown and actionRightCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionRightCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
            local _, actionMiddleName, _, actionMiddleTooltip, actionMiddleCooldown = self:GetActionInfo('spell', self.db.profile[optionName][0]);
            if actionMiddleName then
                GameTooltip:AddLine(L['TOOLTIP_MIDDLECLICK'], 1.0, 1.0, 1.0);
                if actionMiddleTooltip ~= nil then
                    GameTooltip:AddDoubleLine(actionMiddleName, actionMiddleTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
                else
                    GameTooltip:AddLine(actionMiddleName, 0.8, 0.8, 0.1);
                end
                if actionMiddleCooldown and actionMiddleCooldown > 0 then
                    local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionMiddleCooldown);
                    GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
                end                
            end   
        end
    end
end

function Sabella:UpdateStatus()
    if (not InCombatLockdown()) and self.updatePending then
        self:UpdateActions();
    end

    local circleInfo, textInfo = self:SphereGetStatusInfo(self.db.profile.sphereStatusCircle, self.db.profile.sphereStatusText);
    -- update circle
    if self.db.profile.sphereStatusCircle == nil or self.db.profile.sphereStatusCircle == 0 then
        self:SphereSetStatusValues(0, nil);        
    elseif circleInfo ~= nil then
        local statusCircle = 0;
        local hasPet = HasPetUI();
        if circleInfo == 'MANA' then
            statusCircle = math.floor((UnitMana('player') * 16 / UnitManaMax('player')) + 0.5);
        elseif circleInfo == 'HEALTH' then
            statusCircle = math.floor((UnitHealth('player') * 16 / UnitHealthMax('player')) + 0.5);
        elseif circleInfo == 'XP' then
            statusCircle = math.floor((UnitXP('player') * 16 / UnitXPMax('player')) + 0.5);
        end        
        self:SphereSetStatusValues(statusCircle, nil);
    end
    -- update sphere text
    if self.db.profile.sphereStatusText == nil or self.db.profile.sphereStatusText == 0 then
        self:SphereSetStatusValues(nil, '');        
    elseif textInfo ~= nil then
        local statusText = '';
        if textInfo == 'MANA' then
            statusText = (math.floor((UnitMana('player') * 100 / UnitManaMax('player')) + 0.5))..'%\n'..UnitMana('player');
        elseif textInfo == 'HEALTH' then
            statusText = (math.floor((UnitHealth('player') * 100 / UnitHealthMax('player')) + 0.5))..'%\n'..UnitHealth('player');       
        elseif textInfo == 'CP' then
            statusText = GetComboPoints() 
        end
        self:SphereSetStatusValues(nil, statusText);
    end
    -- update potion cooldown
    local _, _, _, _, cooldownHP = self:InventoryGetItemData('POTION_HP');
    local _, _, _, _, cooldownMP = self:InventoryGetItemData('POTION_MP');
    local cooldownString = nil;
    local cooldownUnit = nil;
    if cooldownHP ~= nil and cooldownHP > 0 then
        cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldownHP);
    elseif cooldownMP ~= nil and cooldownMP > 0 then
        cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldownMP);
    end
    if cooldownString then
        self:ButtonSetCaption('Potion', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
        self:ButtonSetStatus('Potion', false);        
    else
        self:ButtonSetCaption('Potion', nil);
        self:ButtonSetStatus('Potion', true);
    end
    local currentMana = UnitMana('player');
    local actionName = nil;
    local actionCooldown = nil;
    local actionMana = nil;
    -- action buttons
    self:UpdateActionButtonStatus('ActionOne', currentMana);
    self:UpdateActionButtonStatus('ActionTwo', currentMana);
    self:UpdateActionButtonStatus('ActionThree', currentMana);
    self:UpdateActionButtonStatus('ActionPoisons', currentMana);
    local actionName = nil;
    local actionCooldown = nil;
    local actionMana = nil;

    -- mount button highlighting
    if UnitOnTaxi('player') then
        self:ButtonSetStatus('Mount', false);
    else
        self:ButtonSetStatus('Mount', true);
        if IsMounted() then
            SabellaButtonMount:LockHighlight();
        else
            SabellaButtonMount:UnlockHighlight(); 
        end
    end
    
    -- update button status (mana depending spells, cooldowns)
    self:ButtonUpdateMenuStatus();
end

function Sabella:UpdateActionButtonStatus(buttonId, currentMana)
    local _, actionName, _, _, actionCooldown, actionMana = self:ButtonGetActionInfo(self.db.profile['button'..buttonId..'Left']);
    if actionName == nil then
        _, actionName, _, _, actionCooldown, actionMana = self:ButtonGetActionInfo(self.db.profile['button'..buttonId..'Right']);        
    end
    local buttonEnabled = true;
    if actionName ~= nil then
        if  actionCooldown ~= nil and actionCooldown > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown);
            if cooldownString then
                self:ButtonSetCaption(buttonId, self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                buttonEnabled = false;
            else
                self:ButtonSetCaption(buttonId, '');        
            end
        else 
            self:ButtonSetCaption(buttonId, '');
        end
        if actionMana ~= nil and actionMana > 0 and actionMana > currentMana then
            buttonEnabled = false;        
        end
    else
        buttonEnabled = false;
    end
    if buttonEnabled then 
        self:ButtonSetStatus(buttonId, true);     
    else
        self:ButtonSetStatus(buttonId, false);      
    end
end

function Sabella:UpdateActions()
    if InCombatLockdown() then
        self.updatePending = true;
        return;
    end
    if self.updatePending then
        self:UpdateTemporaryOptions();
    end
    
    -- sphere    
    actionType, actionName = self:ButtonGetActionInfo(self.db.profile.sphereActionLeft);     
    if actionType ~= nil and actionName then
        if actionType == 'spell' then
            self:SphereSetSpell('LeftButton', actionName);
        else
            self:SphereSetItem('LeftButton',actionName);
        end
    else 
        self:SphereSetSpell('LeftButton', '');
    end
    actionType, actionName = self:ButtonGetActionInfo(self.db.profile.sphereActionRight);    
    if actionType ~= nil and actionName then
        if actionType == 'spell' then
            self:SphereSetSpell('RightButton', actionName);
        else
            self:SphereSetItem('RightButton', actionName);
        end
    else 
        self:SphereSetSpell('RightButton', '');
    end 
    
    -- drink button
    self:UpdateItemButton('Drink', 'FOODBONUS', 'FOOD', 'Spell_Misc_Drink');    
    -- potions button
    self:UpdateItemButton('Potion', 'HEALTHSTONE', 'POTION_HP', 'INV_Potion_90');
    self:UpdateItemButton('Bandage', 'BGBANDAGE', 'BANDAGE', 'INV_Misc_Bandage_02');
    self:UpdateItemButton('Thistle', 'THISTLETEA', 'THISTLETEA', 'INV_Drink_Milk_05');
    
    -- mount button
    local itemMountName, itemMountTexture = self:InventoryGetMountData();
    local _, itemHearthStoneName, itemHearthStoneTexture = self:InventoryGetItemData('HEARTHSTONE');
    if itemMountName ~= nil then        
        self:ButtonSetStatus('Mount', true);
        self:ButtonSetIcon('Mount', itemMountTexture);
        self:ButtonSetMacro('Mount', 'LeftButton', '/dismount\n/use '..itemMountName);
        if itemHearthStoneName ~= nil then
            self:ButtonSetItem('Mount', 'RightButton', itemHearthStoneName);
        else 
            self:ButtonSetItem('Mount', 'RightButton', '');        
        end
    else     
        self:ButtonSetMacro('Mount', 'LeftButton', '/dismount');
        if itemHearthStoneName ~= nil then
            self:ButtonSetIcon('Mount', itemHearthStoneTexture);
            self:ButtonSetItem('Mount', 'RightButton', itemHearthStoneName);
        else 
            self:ButtonSetIcon('Mount', 'INV_Misc_Rune_01');
            self:ButtonSetItem('Mount', 'RightButton', '');        
        end
    end
    
    -- action buttons
    self:UpdateActionButton('ActionOne');
    self:UpdateActionButton('ActionTwo');
    self:UpdateActionButton('ActionThree');
    self:UpdateActionButton('ActionPoisons');
    self:UpdateMenuButtonSpells('StealthMenu', 'Ability_Stealth');
    self:ButtonUpdateMenus();
    -- set remembered spells and show icon for right click
       
    self.updatePending = false;
end

function Sabella:UpdateMenuButtonSpells(menuId, defaultTexture)
    local optionName = 'remember'..menuId;
    if self.db.profile[optionName] ~= nil then
        local actionTypeRight, actionNameRight, actionTextureRight = self:GetActionInfo('spell', self.db.profile[optionName][1]);
        if actionTypeRight ~= nil and actionTypeRight == 'spell' and actionNameRight ~= nil then
            self:ButtonSetSpell(menuId, 'RightButton', actionNameRight);
            if self.db.profile[optionName][1] ~= self.db.profile[optionName][0] then
                local actionTypeMiddle, actionNameMiddle = self:GetActionInfo('spell', self.db.profile[optionName][0]);
                if actionTypeMiddle ~= nil and actionTypeMiddle == 'spell' and actionNameMiddle ~= nil then
                    self:ButtonSetSpell(menuId, 'MiddleButton', actionNameMiddle);
                else 
                    self:ButtonSetSpell(menuId, 'MiddleButton', '');        
                end
            else
                self:ButtonSetSpell(menuId, 'MiddleButton', '');           
            end
        else 
            self:ButtonSetSpell(menuId, 'RightButton', ''); 
            self:ButtonSetSpell(menuId, 'MiddleButton', '');           
        end
        if actionTextureRight then
            self:ButtonSetIcon(menuId, actionTextureRight);
        else 
            self:ButtonSetIcon(menuId, defaultTexture);        
        end
    end
end

function Sabella:UpdateItemButton(buttonId, groupIdLeft, groupIdRight, defaultTexture)
    local _, itemLeftName, itemLeftTexture  = self:InventoryGetItemData(groupIdLeft);
    local _, itemRightName, itemRightTexture  = self:InventoryGetItemData(groupIdRight);
    if itemLeftName ~= nil then
        self:ButtonSetStatus(buttonId, true);
        self:ButtonSetIcon(buttonId, itemLeftTexture);
        self:ButtonSetItem(buttonId, 'LeftButton', itemLeftName);
        if itemRightName ~= nil then
            self:ButtonSetItem(buttonId, 'RightButton', itemRightName);
        else
            self:ButtonSetItem(buttonId, 'RightButton', '');        
        end
    else
        self:ButtonSetItem(buttonId, 'LeftButton', '');
        if itemRightName ~= nil then
            self:ButtonSetStatus(buttonId, true);
            self:ButtonSetIcon(buttonId, itemRightTexture);
            self:ButtonSetItem(buttonId, 'RightButton', itemRightName);
        else
            self:ButtonSetStatus(buttonId, false);
            self:ButtonSetIcon(buttonId, defaultTexture);
            self:ButtonSetItem(buttonId, 'RightButton', '');   
        end
    end
end

function Sabella:UpdateActionButton(buttonId)
    local actionLeftType, actionLeftName, actionLeftTexture = self:ButtonGetActionInfo(self.db.profile['button'..buttonId..'Left']);
    local actionRightType, actionRightName, actionRightTexture = self:ButtonGetActionInfo(self.db.profile['button'..buttonId..'Right']);
    if actionLeftType ~= nil and actionLeftName ~= nil then
        if actionLeftType == 'spell' then
            self:ButtonSetSpell(buttonId, 'LeftButton', actionLeftName);
        else 
            self:ButtonSetItem(buttonId, 'LeftButton', actionLeftName);        
        end
    else
        self:ButtonSetSpell(buttonId, 'LeftButton', '');    
    end
    if actionRightType ~= nil and actionRightName then
        if actionRightType == 'spell' then
            self:ButtonSetSpell(buttonId, 'RightButton', actionRightName);
        else 
            self:ButtonSetItem(buttonId, 'RightButton', actionRightName);        
        end
    else
        self:ButtonSetSpell(buttonId, 'RightButton', '');    
    end
    if actionLeftTexture ~= nil then
        self:ButtonSetIcon(buttonId, actionLeftTexture);
    elseif actionRightTexture ~= nil then
        self:ButtonSetIcon(buttonId, actionRightTexture);
    else 
        self:ButtonSetIcon(buttonId, 'DEFAULT');    
    end
end


function Sabella:OnSpellCastStart(spell, rank, target)
    if spell ~= nil and self.spellTableRevIndex ~= nil then
        if target == nil then
            target = '';
        end
        local spellId = self.spellTableRevIndex[spell];        
        end
    end

function Sabella:OnSpellCast(spell, rank, target)
    if spell ~= nil and self.spellTableRevIndex ~= nil then
        if target == nil then
            target = '';
        end
           if inGroup then
              if spellId ~= nil and spellId == 'SAP' then
                        self:DoSpeech('GROUP_WARNING', 'RAID', 'SAP_SPEECH', target);
                    end
                end
        local spellId = self.spellTableRevIndex[spell];
        -- remember abilities
        if spellId == 'SPRINT' or spellId == 'EVASION' or spellId == 'EVISCERATE' or spellId == 'BLIND' 
            or spellId == 'BACKSTAB' then
	end
	if self.db.profile.messagesRandom then
           if spellId ~= nil and  spellId == 'SPRINT' and self.db.profile.messagesRandomSprint then
                    self:DoSpeech('SAY', 'SPRINT_SPEECH', nil, target);
           elseif spellId ~= nil and  spellId == 'EVISCERATE' and self.db.profile.messagesRandomEvis then
                    self:DoSpeech('SAY', 'EVISCERATE_SPEECH', nil, target);
           elseif spellId ~= nil and  spellId == 'EVASION' and self.db.profile.messagesRandomEvasionSpeech then
                    self:DoSpeech('SAY', 'EVASION_SPEECH', nil, target);
           elseif spellId ~= nil and  spellId == 'BACKSTAB' and self.db.profile.messagesRandomBackStab then
                    self:DoSpeech('SAY', 'BACKSTAB_SPEECH', nil, target);    
           elseif spellId ~= nil and  spellId == 'SAP' and self.db.profile.messagesRandomSap then
                    self:DoSpeech('GROUP_WARNING', 'SAP_SPEECH', nil, target);   
           elseif self.db.profile.messagesRandomMount then
                    local itemMountName, _, itemMountTitle = self:InventoryGetMountData();
                    if itemMountName ~= nil and itemMountTitle ~= nil and itemMountTitle == spell then
                        self:DoSpeech('SAY', 'MOUNT', nil, nil, itemMountTitle);
                    end
                end
            end
        end
end
function Sabella:ButtonRememberSpell(menuId, spellId)
    local optionName = 'remember'..menuId;
    if self.temporary == nil then
        self.temporary = {};
    end
    if self.temporary[optionName] == nil then
        self.temporary[optionName] = { 
            [0] = nil, 
            [1] = nil 
        };
    end
    if InCombatLockdown() or self.updatePending then
        if self.db.profile[optionName] then
            if self.db.profile[optionName][0] and self.temporary[optionName][0] == nil then
                self.temporary[optionName][0] = self.db.profile[optionName][0];
            end
            if self.db.profile[optionName][1] and self.temporary[optionName][1] == nil then
                self.temporary[optionName][1] = self.db.profile[optionName][1];
            end
        end
        if self.temporary[optionName][1] ~= spellId then
            if self.temporary[optionName][1] ~= nil then
                self.temporary[optionName][0] = self.temporary[optionName][1];
            else
                self.temporary[optionName][0] = spellId;
            end
            self.temporary[optionName][1] = spellId;        
        end
        self.updatePending = TRUE;
    elseif self.db.profile[optionName] then
        self.temporary[optionName][0] = nil;
        self.temporary[optionName][1] = nil;
        if self.db.profile[optionName][1] and self.db.profile[optionName][1] ~= spellId then
            if self.db.profile[optionName][1] ~= '' then
                self.db.profile[optionName][0] = self.db.profile[optionName][1];
            else
                self.db.profile[optionName][0] = spellId;
            end
            self.db.profile[optionName][1] = spellId;
            self:UpdateActions();
            GameTooltip:Hide();
        end
    end
end

function Sabella:UpdateTemporaryOptions()
    if (not InCombatLockdown()) and self.updatePending then
        if self.temporary == nil then
            self.temporary = {};
            return;
        end        
        for optionName, optionValue in pairs(self.temporary) do
            if type(optionValue) == 'table' then
                for subOptionName, subOptionValue in pairs(optionValue) do
                    if subOptionValue ~= nil then
                        self.db.profile[optionName][subOptionName] = subOptionValue;
                        self.temporary[optionName][subOptionName] = nil;
                    end
                end
            elseif optionValue ~= nil then
                self.db.profile[optionName] = optionValue;
                self.temporary[optionName] = nil;
            end
        end
    end
end

function Sabella:GetButtonCooldownStr(cooldownString, cooldownUnit) 
    if cooldownUnit == 'h' then
        return '|c00FFCC00'..cooldownString..L['BUTTON_COOLDOWN_HOUR']..'|r';
    elseif cooldownUnit == 'm' then
        return '|c00FFCC00'..cooldownString..L['BUTTON_COOLDOWN_MINUTES']..'|r';
    else
        return '|c00FFCC00'..cooldownString..'|r';
    end
end

function Sabella:GetTooltipCooldownStr(cooldownString, cooldownUnit) 
    if cooldownUnit == 'h' then
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_HOUR'];
    elseif cooldownUnit == 'm' then
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_MINUTES'];
    else
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_SECONDS'];
    end
end

function Sabella_MinimapToggle() 
  SabellaFuBar:ToggleIconShown();
end