SabellaFuBar = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0");

SabellaFuBar.name = "Sabella";
SabellaFuBar.version = Sabella.versions;
SabellaFuBar.date = Sabella.date;
SabellaFuBar.hasIcon = "Interface\\Icons\\Ability_CheapShot";
SabellaFuBar.hasNoColor = true;
SabellaFuBar.defaultMinimapPosition = 285;
SabellaFuBar.clickableTooltip = false;
SabellaFuBar.hideWithoutStandby = true;
SabellaFuBar.independentProfile = true;
SabellaFuBar.cannotDetachTooltip = true;

-- localisation

function SabellaFuBar:OnInitialize()
	self.db = Sabella:AcquireDBNamespace("fubar");
	fubarOptions = {
		type = 'group',
        args = {}
	}
	self.OnMenuRequest = fubarOptions;
end

local L = AceLibrary('AceLocale-2.2'):new('Sabella');
local Tablet = AceLibrary("Tablet-2.0");
local Dewdrop = AceLibrary("Dewdrop-2.0")

function SabellaFuBar:OnTooltipUpdate()
    GameTooltip:Hide();
	local cat = Tablet:AddCategory("columns", 2)
    local itemCount, itemName = Sabella:InventoryGetItemData('FOOD');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('FOODBONUS');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('BANDAGE');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('BGBANDAGE');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('POTION_HP');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('HEALTHSTONE');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('THISTLETEA');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('REAGENT');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('DEADLY_POISON');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('INSTANT_POISON');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('NUMB_POISON');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('CRIPPLE_POISON');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Sabella:InventoryGetItemData('WOUND_POISON');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
	Tablet:SetHint(L['CLICK_TOGGLE_CONFIG']);
end

function SabellaFuBar:OnClick(button)
    GameTooltip:Hide();
    SabellaConfig_Toggle();
end
