local L = AceLibrary("AceLocale-2.2"):new("Historian");
local LS = AceLibrary("AceLocale-2.2"):new("Historian-Shared");
local f = AceLibrary("HistorianFormatting-1.0");

-- *************************************
-- * MigrateData
-- * Imports data stored in old formats
-- *************************************
function Historian:MigrateData()
	-- Migrate old data
	if (HISTORIAN_DATABASE ~= nil) then
		self:Print(L["MSG_IMPORT_OLD_DATA"]);
		
		-- Loot stats
		self.db.char.Loot.MostMoneyEver = f:AsNumber(HISTORIAN_DATABASE["LootStats"]["MostMoneyEver"]);
		
		for i = 1, 6, 1 do
			self.db.char.Loot.ItemsOfQuality[i] = f:AsNumber(HISTORIAN_DATABASE["LootStats"]["LootedItemsOfQuality" .. tostring(i)]);
		end;
		
		-- Levels
		if (HISTORIAN_DATABASE["AdvancementStats"] ~= nil) then
			for i = 1, 80, 1 do
				local key = "Level_" .. tostring(i);

				if (HISTORIAN_DATABASE["AdvancementStats"][key] ~= nil) then
					self.db.char.Advancement.Levels[i] = HISTORIAN_DATABASE["AdvancementStats"][key];
				end;
			end;
		end;
		
		-- Total deaths
		self.db.char.Advancement.TotalDeaths = f:AsNumber(HISTORIAN_DATABASE["DeathStats"]["Deaths"]);
		
		-- Quests completed
		self.db.char.Advancement.QuestsCompleted= f:AsNumber(HISTORIAN_DATABASE["QuestStats"]["QuestsCompleted"]);
		
		-- Other advancements
		self.db.char.Advancement.RecipesLearned = f:AsNumber(HISTORIAN_DATABASE["AdvancementStats"]["RecipesLearned"]);
		
		-- Discoveries
		self.db.char.Discoveries.Areas = f:AsNumber(HISTORIAN_DATABASE["AdvancementStats"]["AreasDiscovered"]);
		
		-- Environmental damage
		self.db.char.EnvironmentalDamage.Drowning.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageDrowningCount"]);
		self.db.char.EnvironmentalDamage.Drowning.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageDrowningDamage"]);

		self.db.char.EnvironmentalDamage.Fatique.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFatiqueCount"]);
		self.db.char.EnvironmentalDamage.Fatique.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFatiqueDamage"]);

		self.db.char.EnvironmentalDamage.Falling.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFallingCount"]);
		self.db.char.EnvironmentalDamage.Falling.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFallingDamage"]);
		
		self.db.char.EnvironmentalDamage.Fire.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFireCount"]);
		self.db.char.EnvironmentalDamage.Fire.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageFireDamage"]);
		
		self.db.char.EnvironmentalDamage.Lava.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageLavaCount"]);
		self.db.char.EnvironmentalDamage.Lava.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageLavaDamage"]);
		
		self.db.char.EnvironmentalDamage.Slime.Times = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageSlimeCount"]);
		self.db.char.EnvironmentalDamage.Slime.TotalDamage = f:AsNumber(HISTORIAN_DATABASE["DamageStats"]["EnvironmentDamageSlimeDamage"]);
		
		-- Follow
		self.db.char.Follow.MostFollowed.Count = f:AsNumber(HISTORIAN_DATABASE["MiscStats"]["MostFollowedCount"]);
		self.db.char.Follow.MostFollowed.Name = HISTORIAN_DATABASE["MiscStats"]["MostFollowedPlayer"];

		for key, value in pairs(HISTORIAN_DATABASE["MiscStats"]) do
			if (key == "MostFollowedCount") then
				self.db.char.Follow.MostFollowed.Count = f:AsNumber(value);
			else 
				if (key == "MostFollowedPlayer") then
					self.db.char.Follow.MostFollowed.Name = value;
				else
					local playerName = string.sub(key, 15);
					self.db.char.Follow.Players[playerName] = f:AsNumber(value);
				end;
			end;
		end;

		-- Kills
		for key, value in pairs(HISTORIAN_DATABASE["KillStats"]) do
			if (key == "_FavoritePreyCount") then
				self.db.char.Kills.Favorite.Count = f:AsNumber(value);
			else 
				if (key == "_FavoritePrey") then
					self.db.char.Kills.Favorite.Name = value;
				else
					if (key == "_MobsKilled") then
						self.db.char.Kills.Total = f:AsNumber(value);
					else
						self.db.char.Kills.Mobs[key] = f:AsNumber(value);
					end;
				end;
			end;
		end;

		

		self:Print(L["MSG_IMPORT_COMPLETE"]);
		HISTORIAN_DATABASE = nil;
	end;
	
	if (self.db.char.DataVersion == 0) then
		-- DataVersion was introduced in version 1.0.1.8
		self:Print(L["MSG_IMPORT_OLD_DATA"]);
		
		-- Move all existing kills to "killing blows".
		if (self.db.char.Kills ~= nil) then
			if (self.db.char.Kills.Mobs ~= nil) then
				local newData = {};
				
				for key, value in pairs(self.db.char.Kills.Mobs) do
					newData[key] = {};
					newData[key].KillingBlows = value;
					newData[key].Any = value;
				end;
				
				self.db.char.Kills.Mobs = newData;
			end;
			
			self.db.char.Kills.TotalKillingBlows = self.db.char.Kills.Total;
		end;
		
		self:Print(L["MSG_IMPORT_COMPLETE"]);
	end;
	
	self.db.char.DataVersion = self.version;
end;