local LS = AceLibrary("AceLocale-2.2"):new("Historian-Shared");

LS:RegisterTranslations("enUS", function() return {
	-- Slash commands
	["CMD_GUI_TITLE"] = "Show GUI",
	["CMD_GUI_DESC"] = "Toggles display of the Historian window.",
		
	["CMD_SHOWTOOLTIP_TITLE"] = "Show tooltip on enemies",
	["CMD_SHOWTOOLTIP_DESC"] = "Displays various statistics when your mouse is over known enemies.",
		
	["CMD_COUNTPARTYKILLS_TITLE"] = "Count party kills",
	["CMD_COUNTPARTYKILLS_DESC"] = "If enabled, your kill statistics will include those by your fellow party members.",
	
	["CMD_COUNTINSTANCEKILLS_TITLE"] = "Count all instance kills",
	["CMD_COUNTINSTANCEKILLS_DESC"] = "If enabled, your statistics will include all nearby kills when you are in an instance.",

	["CMD_FIRST_USE_TITLE"] = "First use",
	["CMD_FIRST_USE_DESC"] = "Outputs the date of the first time Historian was loaded for this character.",
	
	-- Statistics
	["NOT_AVAILABLE"] = " -- ";
	
	["STAT_CATEGORY_FORTUNE"] = "Fortune",
	["STAT_MAX_MONEY"] = "Money at peak",
	
	["STAT_CATEGORY_ITEMS_LOOTED"] = "Items received",
	["STAT_LOOTED_COMMON"] = "Common",
	["STAT_LOOTED_UNCOMMON"] = "Uncommon",
	["STAT_LOOTED_RARE"] = "Rare",
	["STAT_LOOTED_EPIC"] = "Epic",
	["STAT_LOOTED_LEGENDARY"] = "Legendary",
	["STAT_LOOTED_ARTIFACT"] = "Artifact",
	
	["STAT_CATEGORY_ACHIEVEMENTS"] = "Achievements",
	["STAT_QUESTS_COMPLETED"] = "Quests completed",
	["STAT_RECIPES_LEARNED"] = "Recipes learned",
	["STAT_AREAS_DISCOVERED"] = "Areas discovered",
	["STAT_TOTAL_SPELLS"] = "Total spells casts",
	["STAT_TOTAL_KILLS"] = "Total mobs killed",
	
	["STAT_CATEGORY_DISAPPOINTMENTS"] = "Disappointments",
	["STAT_ENV_DROWNING"] = "Drowning",
	["STAT_ENV_FATIGUE"] = "Fatigued",
	["STAT_ENV_FALL"] = "Fallen down",
	["STAT_ENV_FIRE"] = "Burnt",
	["STAT_ENV_LAVA"] = "Tasted lava",
	["STAT_ENV_SLIME"] = "Bathed in slime",
	["STAT_ENV_VALUE"] = "%s times (%s damage)",
	["STAT_ENV_VALUE_SINGLE"] = "Once (%s damage)",
	["STAT_DEATHS"] = "Just plain dead",
	["STAT_DEATHS_VALUE"] = "%s times",
	["STAT_DEATHS_VALUE_SINGLE"] = "Once",
	
	["STAT_CATEGORY_HABITS"] = "Habits",
	["STAT_MOST_FOLLOWED"] = "Most followed player",
	["STAT_MOST_FOLLOWED_VALUE"] = "%s (%s times)",
	["STAT_MOST_FOLLOWED_VALUE_SINGLE"] = "%s (once)",
	["STAT_FAVORITE_PREY"] = "Favorite prey",
	["STAT_FAVORITE_PREY_VALUE"] = "%s (%s killed)",
	["STAT_FAVORITE_SPELL"] = "Favorite spell",
	["STAT_FAVORITE_SPELL_VALUE"] = "%s (%s casts)",
	["STAT_FOOD"] = "Had a snack",
	["STAT_DRINK"] = "Had a drink",
	["STAT_FOOD_VALUE"] = "%s times",
	["STAT_DRINK_VALUE"] = "%s times",
	["STAT_TIPSY"] = "Been a little tipsy",
	["STAT_TIPSY_VALUE"] = "%s times",
	["STAT_DRUNK"] = "Been drunk",
	["STAT_DRUNK_VALUE"] = "%s times",
	["STAT_SMASHED"] = "Been completely smashed",
	["STAT_SMASHED_VALUE"] = "%s times",
	["STAT_JUMPS"] = "Jumps",
	["STAT_AFK"] = DEFAULT_AFK_MESSAGE,
	
	["STAT_CATEGORY_KILL_DETAILS"] = "Kills",
	["STAT_CATEGORY_SPELL_DETAILS"] = "Spells",
	["STAT_CATEGORY_LEVEL_DETAILS"] = "Levels",
	
	["STAT_KILLS_NONE"] = "You have not killed anything since installing Historian.",
	["STAT_SPELLS_NONE"] = "You have not cast any spells since installing Historian.",
	["STAT_LEVELS_NONE"] = "There is no level information available.",
	["STAT_LEVEL_X"] = "Level %s",
	
	-- Chat inserts
	["CHAT_INSERT_MAX_MONEY"] = "The most money I have ever had is %s.",
	["CHAT_INSERT_LOOTED_COMMON"] = "I have looted %s common item(s) to date.",
	["CHAT_INSERT_LOOTED_UNCOMMON"] = "I have looted %s uncommon item(s) to date.",
	["CHAT_INSERT_LOOTED_RARE"] = "I have looted %s rare item(s) to date.",
	["CHAT_INSERT_LOOTED_EPIC"] = "I have looted %s epic item(s) to date.",
	["CHAT_INSERT_LOOTED_LEGENDARY"] = "I have looted %s legendary item(s) to date.",
	["CHAT_INSERT_LOOTED_ARTIFACT"] = "I have looted %s artifact item(s) to date.",
	["CHAT_INSERT_QUESTS_COMPLETED"] = "I have completed %s quest(s) so far.",
	["CHAT_INSERT_RECIPES_LEARNED"] = "I have learned %s recipe(s) so far.",
	["CHAT_INSERT_AREAS_DISCOVERED"] = "I have discovered %s area(s) so far.",
	["CHAT_INSERT_TOTAL_SPELLS"] = "I have cast %s spell(s) so far.",
	["CHAT_INSERT_TOTAL_KILLS"] = "I have killed %s mob(s) so far.",
	
	["CHAT_INSERT_ENV_DROWNING"] = "I have drowned %s times for a total of %s damage.",
	["CHAT_INSERT_ENV_FATIGUE"] = "I have been fatigued %s times for a total of %s damage.",
	["CHAT_INSERT_ENV_FALL"] = "I have fallen %s times for a total of %s damage.",
	["CHAT_INSERT_ENV_FIRE"] = "I have taken fire damage %s times for a total of %s damage.",
	["CHAT_INSERT_ENV_LAVA"] = "I have taken lava damage %s times for a total of %s damage.",
	["CHAT_INSERT_ENV_SLIME"] = "I have stepped in slime %s times for a total of %s damage.",
	["CHAT_INSERT_DEATHS"] = "I have died %s times so far.",
	
	["CHAT_INSERT_MOST_FOLLOWED"] = "I have followed %s around %s times.",
	["CHAT_INSERT_FAVORITE_PREY"] = "My favorite prey is %s (%s kills)",
	["CHAT_INSERT_FAVORITE_SPELL"] = "My favorite spell is %s (%s casts)",
	["CHAT_INSERT_FOOD"] = "I have eaten food %s times.",
	["CHAT_INSERT_DRINK"] = "I have had a drink %s times.",
	["CHAT_INSERT_JUMPS"] = "I have jumped %s times.",
	["CHAT_INSERT_TIPSY"] = "I have been a little tipsy %s times.",
	["CHAT_INSERT_DRUNK"] = "I have been drunk %s times.",
	["CHAT_INSERT_SMASHED"] = "I have been completely smashed %s times.",
	["CHAT_INSERT_AFK"] = "I have been Away From Keyboard %s times.",
} end)



local L = AceLibrary("AceLocale-2.2"):new("Historian");

L:RegisterTranslations("enUS", function() return {
	-- Slash commands
	["SLASH-COMMANDS"] = { "/historian", "/hist", "/stats" },

	["CMD_REPORT_TITLE"] = "Report",
	["CMD_REPORT_DESC"] = "Writes statistics about your character to the chat.",

	-- Status messages
	["MSG_IMPORT_OLD_DATA"] = "Importing old data...",
	["MSG_IMPORT_COMPLETE"] = "Import complete.",

	-- Chat report
	["MSG_REPORT_HEADER"] = "----------- Historian Report -----------",
	["MSG_REPORT_SEPARATOR"] = "--",
	["MSG_REPORT_NOTE"] = "NOTE: You probably need to scroll up to see the entire report. Get FuBar to see this in a nice GUI :)",
		

	-- Buffs
	["BUFF_FOOD"] = "Food", -- NOTE: This MUST match the name of the aura you get when you eat something
	["BUFF_DRINK"] = "Drink", -- NOTE: This MUST match the name of the aura you get when you drink something
	
	-- Tooltip
	["MSG_TOOLTIP_KILLED"] = "Killed %s times.",
	["MSG_TOOLTIP_KILLED_SINGLE"] = "Killed 1 time.",
	["MSG_TOOLTIP_KILLED_WITH_KB"] = "Killed %s times (%s k.b.).",

	["MSG_FIRST_USE"] = "%s used Historian for the first time on %s.",
} end)



local LFu = AceLibrary("AceLocale-2.2"):new("HistorianFu");

LFu:RegisterTranslations("enUS", function() return {
	["HINT"] = "Click a line to insert it into the chat.",
} end)